#pyinstaller --onefile --noconsole --icon=icone.ico downloader.py
import os
import subprocess
import threading
import tkinter as tk
from tkinter import filedialog, messagebox, ttk
from PIL import Image, ImageTk
import random
import glob

# Nome do arquivo wget.exe (assumindo que ele está no mesmo diretório do script)
WGET_EXECUTAVEL = os.path.join(os.getcwd(), "wget.exe")

# Nome do arquivo de lista de downloads
LISTA_DOWNLOADS = "list.txt"

# Pasta onde estão as imagens do slide
PASTA_SLIDE = os.path.join(os.getcwd(), "slide")

# Criar a janela principal
root = tk.Tk()
root.title("Downloader v1.0")
root.geometry("600x500")  # Aumentei o tamanho para acomodar o novo layout
root.resizable(False, False)  # Impede redimensionamento da janela
#root.attributes("-toolwindow", True)  # Remove botão de maximizar
root.iconbitmap("icone.ico")  # Define o ícone da janela

# Variáveis da interface
pasta_var = tk.StringVar()
progresso_percentual = tk.IntVar()  # Para a barra de progresso
status_var = tk.StringVar(value="Aguardando...")  # Texto de status

# Carregar imagens do slide
def carregar_imagens():
    imagens = glob.glob(os.path.join(PASTA_SLIDE, "*.png")) + glob.glob(os.path.join(PASTA_SLIDE, "*.jpg"))
    return imagens if imagens else None

imagens_slide = carregar_imagens()

# Atualizar a imagem no slide
def atualizar_slide():
    if imagens_slide:
        img_path = random.choice(imagens_slide)  # Escolhe uma imagem aleatória
        img = Image.open(img_path)
        img = img.resize((600, 320), Image.Resampling.LANCZOS)  # Redimensiona a imagem para ocupar 75% da tela
        img_tk = ImageTk.PhotoImage(img)
        slide_label.config(image=img_tk)
        slide_label.image = img_tk  # Mantém a referência para evitar que o garbage collector delete a imagem

    root.after(5000, atualizar_slide)  # Muda a imagem a cada 5 segundos

# Função para escolher diretório
def escolher_diretorio():
    pasta = filedialog.askdirectory()
    if pasta:
        pasta_var.set(pasta)

# Função para atualizar a barra de progresso
def atualizar_progresso(porcentagem, mensagem="Baixando..."):
    progresso_percentual.set(porcentagem)
    status_var.set(mensagem)
    root.update_idletasks()

# Função para iniciar os downloads do list.txt
def iniciar_download():
    pasta = pasta_var.get()

    if not pasta:
        messagebox.showerror("Erro", "Escolha uma pasta de destino!")
        return

    if not os.path.exists(LISTA_DOWNLOADS):
        messagebox.showerror("Erro", f"O arquivo '{LISTA_DOWNLOADS}' não foi encontrado!")
        return

    def baixar():
        try:
            with open(LISTA_DOWNLOADS, "r", encoding="utf-8") as file:
                links = [linha.strip() for linha in file if linha.strip()]  # Remove linhas vazias

            if not links:
                messagebox.showerror("Erro", "O arquivo list.txt está vazio!")
                return

            total_links = len(links)

            for index, url in enumerate(links, start=1):
                nome_arquivo = os.path.basename(url)  # Obtém o nome do arquivo da URL
                caminho_completo = os.path.join(pasta, nome_arquivo)

                atualizar_progresso(0, f"Iniciando {index}/{total_links}...")

                # Comando para executar o wget.exe baixando todos os arquivos da lista
                comando = f'"{WGET_EXECUTAVEL}" --progress=dot -P "{pasta}" "{url}"'

                # Executa o wget e captura a saída
                processo = subprocess.Popen(comando, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT, text=True)

                for linha in processo.stdout:
                    if "%" in linha:  # Captura progresso do wget
                        try:
                            porcentagem = int(linha.split("%")[0].strip().split()[-1])
                            atualizar_progresso(porcentagem, f"Baixando {index}/{total_links}... {porcentagem}%")
                        except ValueError:
                            pass  # Se não conseguir extrair a porcentagem, ignora

                processo.wait()  # Aguarda o processo terminar

                if processo.returncode == 0:
                    atualizar_progresso(100, f"Download {index}/{total_links} concluído!")
                else:
                    messagebox.showwarning("Aviso", f"Erro ao baixar {url}. Código: {processo.returncode}")

            messagebox.showinfo("Sucesso", "Todos os downloads foram concluídos!")
            atualizar_progresso(100, "Todos os downloads finalizados!")

        except Exception as e:
            messagebox.showerror("Erro", f"Falha ao baixar: {e}")

    # Criar uma thread para rodar o download sem travar a interface
    thread = threading.Thread(target=baixar)
    thread.start()

# Slide de Imagens (parte superior)
slide_label = ttk.Label(root)
slide_label.pack(pady=5)

# Área de seleção de pasta
frame_pasta = ttk.Frame(root, padding=10)
frame_pasta.pack(fill="x", padx=20)

ttk.Button(frame_pasta, text="Escolher Pasta", command=escolher_diretorio).pack(side="left")
ttk.Label(frame_pasta, textvariable=pasta_var, relief="sunken", anchor="w", width=40).pack(side="left", padx=10)

# Barra de progresso
progress_bar = ttk.Progressbar(root, length=500, mode="determinate", variable=progresso_percentual)
progress_bar.pack(pady=10)

# Status do download
ttk.Label(root, textvariable=status_var, font=("Arial", 10)).pack(pady=5)

# Botão de Iniciar Download (fica na parte inferior)
ttk.Button(root, text="Iniciar Download", command=iniciar_download).pack(pady=10)

# Iniciar a troca automática de imagens
atualizar_slide()

# Executar a interface
root.mainloop()
